/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.AbstractStoreSchedule;
import cz.insophy.inplan.store.AbstractStoreView;
import cz.insophy.inplan.store.DefaultStoreSchedule;
import cz.insophy.inplan.store.EstimatePairingStoreView;
import cz.insophy.inplan.store.MergingStoreView;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.store.TransactionPairingStoreView;
import cz.insophy.inplan.util.TimeSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class StoreScheduleGroup {
    private final Map<StoreType, StoreSchedule> schedules;
    private final Map<StoreType, StoreSchedule> primitiveSchedules;

    public StoreScheduleGroup(Collection<Material> materials) {
        EnumMap<StoreType, AbstractStoreSchedule> schds = Maps.newEnumMap(StoreType.class);
        EnumMap<StoreType, DefaultStoreSchedule> primitiveSchds = Maps.newEnumMap(StoreType.class);
        block6: for (StoreType type : StoreType.values()) {
            switch (type) {
                case EXTERNAL: 
                case INPLAN_ACTUAL: 
                case INPLAN_POSSIBLE: 
                case TRANSACTION: {
                    DefaultStoreSchedule ss = new DefaultStoreSchedule(materials);
                    schds.put(type, ss);
                    primitiveSchds.put(type, ss);
                    continue block6;
                }
                case TRANSACTION_PAIRING_VIEW: {
                    schds.put(type, new TransactionPairingStoreView((StoreSchedule)schds.get((Object)StoreType.INPLAN_ACTUAL), (StoreSchedule)schds.get((Object)StoreType.TRANSACTION)));
                    continue block6;
                }
                case ACTUAL_ESTIMATE_VIEW: {
                    schds.put(type, new MergingStoreView((StoreSchedule)schds.get((Object)StoreType.EXTERNAL), (StoreSchedule)schds.get((Object)StoreType.TRANSACTION_PAIRING_VIEW)));
                    continue block6;
                }
                case POSSIBLE_ESTIMATE_VIEW: {
                    schds.put(type, new EstimatePairingStoreView((StoreSchedule)schds.get((Object)StoreType.INPLAN_POSSIBLE), (StoreSchedule)schds.get((Object)StoreType.ACTUAL_ESTIMATE_VIEW)));
                }
            }
        }
        this.schedules = Collections.unmodifiableMap(schds);
        this.primitiveSchedules = Collections.unmodifiableMap(primitiveSchds);
    }

    public StoreSchedule getSchedule(StoreType type) {
        StoreSchedule schedule = this.schedules.get((Object)type);
        if (schedule == null) {
            throw new IllegalArgumentException("Unknown type " + type + " for " + this);
        }
        return this.schedules.get((Object)type);
    }

    public Iterable<? extends Activity> primitiveActivities() {
        ArrayList<Iterable<StoreActivity>> itrbls = Lists.newArrayListWithCapacity(StoreType.values().length);
        for (StoreSchedule ss : this.primitiveSchedules.values()) {
            itrbls.add(ss.activities());
        }
        return Iterables.concat(itrbls);
    }

    public int getPrimitiveActivityCount() {
        int cnt = 0;
        for (StoreSchedule ss : this.primitiveSchedules.values()) {
            cnt += ss.getActivityCount();
        }
        return cnt;
    }

    public void removeAllActivities() {
        for (StoreSchedule ss : this.schedules.values()) {
            if (ss instanceof AbstractStoreView) {
                AbstractStoreView asv = (AbstractStoreView)ss;
                asv.updateEveryCache();
                continue;
            }
            ss.removeAllActivities();
        }
    }

    public TimeSpan getTimeBounds() {
        Iterable<TimeSpan> ssBounds = Iterables.transform(this.primitiveSchedules.values(), new Function<StoreSchedule, TimeSpan>(){

            @Override
            public TimeSpan apply(StoreSchedule from) {
                return from.getTimeBounds();
            }
        });
        return TimeSpan.union(ssBounds);
    }
}

